# 画面設計書 57-メール通知（テキスト - Zurb 2）

## 概要

本ドキュメントは、Symfony 8.1のTwig Bridgeが提供するZurb 2フレームワーク対応のテキスト形式メール通知テンプレート（`zurb_2/notification/body.txt.twig`）の画面設計書である。このテンプレートは、SymfonyのNotifierコンポーネントと連携してプレーンテキスト形式の通知メールを生成する。Zurb 2テーマのHTML版（No.56）と対になるテキスト版であり、HTMLメールを表示できない環境向けのフォールバックコンテンツを提供する。デフォルトテーマのテキスト版（No.55）から継承されるベーステンプレートでもある。

### 本画面の処理概要

**業務上の目的・背景**：メール通知においてHTMLとテキストの両形式を提供することは、RFC 2046で定義されたmultipart/alternativeの仕組みに準拠したベストプラクティスである。テキスト形式のメールは、HTMLを表示できないメールクライアント、アクセシビリティ支援技術（スクリーンリーダー等）、テキスト表示を好むユーザー設定、およびスパムフィルタの通過率向上に寄与する。本テンプレートは、Zurb 2テーマにおけるテキスト形式の通知メール出力を担当し、最小限のプレーンテキスト構造で通知内容を伝達する。

**画面へのアクセス方法**：本テンプレートはWebブラウザでアクセスするものではなく、メールクライアントでテキスト表示されるコンテンツとして受信される。`NotificationEmail`クラスの`getTextTemplate()`メソッドがテンプレートパスを返し、`BodyRenderer`がレンダリングを実行する。`theme()`メソッドで`zurb_2`を設定するか、デフォルトテーマ（内部的に本テンプレートを継承）を使用する。

**主要な操作・処理内容**：
1. メール件名の出力 - `email.subject`変数を`lead`ブロックでプレーンテキストとして出力する
2. コンテンツ本文の出力 - `content`変数を`content`ブロックでプレーンテキストとして出力する
3. アクションリンクの出力 - `action_url`指定時に「テキスト: URL」形式でリンク情報を`action`ブロックで出力する
4. 例外情報の出力 - 例外が添付されている場合、通知メッセージと例外スタックトレースを`exception`ブロックでテキスト出力する

**画面遷移**：テキスト形式のメールであるため、URLはプレーンテキストとして表示される。メールクライアントの多くはURLを自動的にリンク化するが、遷移動作はメールクライアントに依存する。

**権限による表示制御**：テキスト版では`importance`や`footer_text`を出力するブロックが定義されていないため、`markAsPublic()`による制御はテキスト版の表示に直接的な影響を与えない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | Notifier | 主機能 | Notifierコンポーネントからのメール通知トリガーによるZurb 2対応テキストメールテンプレートのレンダリング |
| 40 | Mailer | 補助機能 | Mailerコンポーネントによるメール送信処理 |
| 42 | Mime | 補助機能 | MIMEメッセージとしてのテキストメール本文構成 |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのメール通知テンプレート（Zurb 2スタイル）によるテキストレンダリング |

## 画面種別

メールテンプレート（テキスト形式メール通知 - Zurb 2スタイル）

## URL/ルーティング

本テンプレートはWebルーティングではなく、Twigテンプレートパスで参照される。

| パス | 説明 |
|-----|------|
| `@email/zurb_2/notification/body.txt.twig` | Zurb 2テーマのテキストメール通知テンプレート |

## 入出力項目

| 変数名 | 型 | 必須 | デフォルト値 | 説明 |
|--------|-----|------|-------------|------|
| email.subject | string | Yes | - | メール件名 |
| content | string | No | `''` | メール本文コンテンツ |
| action_url | string/null | No | `null` | アクションリンク先URL |
| action_text | string/null | No | `null` | アクションリンクテキスト |
| exception | bool/string | No | `false` | 例外情報（例外スタックトレース文字列） |

## 表示項目

| 表示セクション | ブロック名 | 出力形式 | 説明 |
|---------------|-----------|---------|------|
| メール件名 | lead | `{email.subject}` | メール件名をプレーンテキストで出力 |
| コンテンツ本文 | content | `{content}` | コンテンツをプレーンテキストで出力 |
| アクションリンク | action | `{action_text}: {action_url}` | テキスト形式のリンク情報（action_url指定時のみ） |
| 例外通知 | exception | `Exception stack trace attached.\n{exception}` | 例外通知メッセージとスタックトレース（exception指定時のみ） |

## イベント仕様

### 1-メール送信トリガー

`NotificationEmail`クラスのインスタンスが`Mailer`コンポーネントを通じて送信される際に、`getTextTemplate()`メソッドが`@email/zurb_2/notification/body.txt.twig`パスを返し（theme=zurb_2の場合）、Twig Environmentがレンダリングを実行する。

### 2-leadブロック（メール件名）

`{% block lead %}`ブロックで`{{ email.subject }}`を出力する。HTML版のような`<p class="lead">`等のタグは使用されず、プレーンテキストとして出力される。

### 3-contentブロック（本文）

`{% block content %}`ブロックで`{{ content }}`を出力する。HTML版のようなMarkdown変換やraw/nl2br分岐は行われず、コンテンツがそのままテキストとして出力される。

### 4-actionブロック（リンク）

`{% block action %}`ブロックで、`action_url`が真の場合のみ`{{ action_text }}: {{ action_url }}`の形式でリンク情報を出力する。

### 5-exceptionブロック（例外情報）

`{% block exception %}`ブロックで、`exception`が真の場合に「Exception stack trace attached.」のメッセージと`{{ exception }}`（例外情報文字列）を出力する。

## データベース更新仕様

### 操作別データベース影響一覧

本テンプレートはメールのテキスト生成のみを担当し、データベース操作は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージ種別 | 表示条件 | 表示形式 | 内容 |
|---------------|---------|---------|------|
| 例外通知メッセージ | `exception == true` | プレーンテキスト | `Exception stack trace attached.` |

## 例外処理

本テンプレート自体には例外処理は含まない。テンプレートの読み込みに失敗した場合は、Twigのテンプレートローダーが例外をスローする。

## 備考

- テキスト版テンプレートは21行のシンプルな構造であり、InkyやCSSインライン化の処理は不要
- HTML版（No.56）と比較して、`importance`、`markdown`、`raw`、`footer_text`の変数は使用されない
- デフォルトテーマのテキスト版（No.55、`default/notification/body.txt.twig`）はこのテンプレートを1行で`{% extends %}`により継承している
- テンプレートは4つのTwigブロック（lead、content、action、exception）を定義しており、子テンプレートで個別にオーバーライド可能
- `exception`変数はテキスト版では文字列として直接出力される。`NotificationEmail::exception()`メソッドで設定される場合、`getExceptionAsString()`メソッドにより例外のクラス名、メッセージ、ファイル・行、スタックトレースが文字列化される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

`NotificationEmail`クラスのコンテキスト変数と`getTextTemplate()`の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NotificationEmail.php | `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php` | `getTextTemplate()`メソッド（行159-166）の実装。`@email/{theme}/notification/body.txt.twig`を返す。`getExceptionAsString()`メソッド（行237-253）で例外がテキストに変換される仕組みを確認 |

**読解のコツ**: `getTextTemplate()`は`parent::getTextTemplate()`が値を返す場合はそれを優先する。これによりユーザーがカスタムテキストテンプレートを設定できる仕組みとなっている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | body.txt.twig（zurb_2） | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.txt.twig` | テンプレート本体（21行）。4つのブロックで構成されたシンプルなテキスト出力 |

**主要処理フロー**:
1. **行1-3**: `{% block lead %}` - `{{ email.subject }}`でメール件名を出力
2. **行5-7**: `{% block content %}` - `{{ content }}`で本文を出力
3. **行9-13**: `{% block action %}` - `{% if action_url %}`の条件付きで`{{ action_text }}: {{ action_url }}`を出力
4. **行15-21**: `{% block exception %}` - `{% if exception %}`の条件付きで通知メッセージと`{{ exception }}`を出力

#### Step 3: デフォルトテーマとの関係を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | body.txt.twig（default） | `src/Symfony/Bridge/Twig/Resources/views/Email/default/notification/body.txt.twig` | デフォルトテーマのテキストテンプレート。1行のみで本テンプレートを継承 |

#### Step 4: HTML版との対比で理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | body.html.twig（zurb_2） | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.html.twig` | HTML版テンプレート（67行）。テキスト版との変数使用の差異を比較する。HTML版ではimportance、markdown、raw、footer_textが追加で使用される |

### プログラム呼び出し階層図

```
NotificationEmail::send()
    |
    +-- Mailer（メール送信処理）
    |       |
    |       +-- BodyRenderer（テンプレートレンダリング）
    |               |
    |               +-- getTextTemplate() -> '@email/zurb_2/notification/body.txt.twig'
    |               |
    |               +-- Twig Environment
    |                       |
    |                       +-- body.txt.twig（zurb_2）
    |                       |       |
    |                       |       +-- leadブロック（email.subject出力）
    |                       |       +-- contentブロック（content出力）
    |                       |       +-- actionブロック（action_text: action_url出力）
    |                       |       +-- exceptionブロック（例外情報出力）
    |                       |
    |                       +-- NotificationEmail::getContext()
    |                               |
    |                               +-- content, action_url, action_text, exception
```

### データフロー図

```
[入力]                              [処理]                              [出力]

NotificationEmail                   body.txt.twig (zurb_2)              プレーンテキスト
├── email.subject                    |                                  メール本文
├── content                          +-- leadブロック                   ├── メール件名
├── action_url/text                  +-- contentブロック                ├── 本文テキスト
└── exception                        +-- actionブロック                 ├── "テキスト: URL"
        |                            +-- exceptionブロック              └── 例外スタックトレース
        +---> Twig Engine ---> プレーンテキスト出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| body.txt.twig（zurb_2） | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.txt.twig` | テンプレート | Zurb 2テーマテキストメールレイアウト本体（21行） |
| body.txt.twig（default） | `src/Symfony/Bridge/Twig/Resources/views/Email/default/notification/body.txt.twig` | テンプレート | デフォルトテーマ（本テンプレートを継承、1行） |
| body.html.twig（zurb_2） | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.html.twig` | テンプレート | 対になるHTML版テンプレート（67行） |
| NotificationEmail.php | `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php` | ソース | 通知メールクラス。getTextTemplate()でテキストテンプレートパスを返す（281行） |
